<?php $__env->startSection('title', 'Sales Report'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Sales Report</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-aqua"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Direct Sales Profit</span>
                    <span class="info-box-number">$<?php echo e(number_format($directSalesProfit, 2)); ?></span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-green"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Sell Transactions Profit</span>
                    <span class="info-box-number">$<?php echo e(number_format($sellTransactionsProfit, 2)); ?></span>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-box">
                <span class="info-box-icon bg-yellow"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Net Profit</span>
                    <span class="info-box-number">$<?php echo e(number_format($netProfit, 2)); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Direct Sales</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Sell Price</th>
                        <th>Profit</th>
                        <th>Date Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $directSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>$<?php echo e(number_format($sale->direct_sell_price, 2)); ?></td>
                            <td>$<?php echo e(number_format($sale->direct_profit, 2)); ?></td>
                            <td><?php echo e($sale->direct_date_time); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Sell Transactions</h3>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Sell Price</th>
                        <th>Profit</th>
                        <th>Date Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $sellTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>$<?php echo e(number_format($transaction->sell_price, 2)); ?></td>
                            <td>$<?php echo e(number_format($transaction->profit, 2)); ?></td>
                            <td><?php echo e($transaction->date_time); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="/css/admin_custom.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script> console.log('Hi!'); </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/index.blade.php ENDPATH**/ ?>