

<?php $__env->startSection('main'); ?>
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Invoice</h1>
                </div>
                <div class="col-sm-6 d-flex justify-content-end">
                    <button onclick="window.print();" class="btn btn-primary btn-lg"><i class="fas fa-print"></i> Print Invoice</button>
                </div>
            </div>
        </div>
    </section>

    <div class="invoice-container" style="max-width: 900px; margin: 0 auto; padding: 30px; background: #f8f9fa; border-radius: 10px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
        <div class="row invoice-header" style="border-bottom: 2px solid #343a40; padding-bottom: 20px; margin-bottom: 20px;">
            <div class="col-12">
                <h4 class="font-weight-bold text-dark">
                    <i class="fas fa-globe"></i> Sales Invoice
                    <small class="float-right text-muted" style="font-size: 16px;">
                        Date: <?php echo e(\Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d')); ?>

                    </small>
                </h4>
            </div>
        </div>

        <div class="row invoice-info mb-3">
            <div class="col-sm-4 invoice-col">
                <h5 class="font-weight-bold">From</h5>
                <address>
                    <strong>Your Company, Inc.</strong><br>
                    123 Your Street<br>
                    Your City, Your Country<br>
                    Phone: (555) 555-5555<br>
                    Email: info@yourcompany.com
                </address>
            </div>

            <div class="col-sm-4 invoice-col">
                <h5 class="font-weight-bold">To</h5>
                <address>
                    <strong><?php echo e($sale->customer_name); ?></strong><br>
                    Phone: <?php echo e($sale->customer_mobile); ?><br>
                </address>
            </div>

            <div class="col-sm-4 invoice-col">
                <h5 class="font-weight-bold">Invoice Details</h5>
                <b>Invoice #<?php echo e($sale->id); ?></b><br>
                <b>Sale Date:</b> <?php echo e(\Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d')); ?><br>
            </div>
        </div>

        <div class="row">
            <div class="col-12 table-responsive">
                <table class="table table-bordered table-striped" style="border-collapse: collapse;">
                    <thead class="bg-light">
                        <tr>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">Brand/Type</th>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">Model/Name</th>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">IMEI/SN</th>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">Selling Price</th>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">Quantity</th>
                            <th class="text-center" style="padding: 12px; font-size: 16px;">Total Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-center" style="padding: 12px;"><?php echo e(e($sale->product->brand)); ?> <?php echo e(e($sale->product->type)); ?></td>
                            <td class="text-center" style="padding: 12px;"><?php echo e(e($sale->product->model)); ?> <?php echo e(e($sale->product->name)); ?></td>
                            <td class="text-center" style="padding: 12px;"><?php echo e($sale->product->imei_or_sn); ?></td>
                            <td class="text-center" style="padding: 12px;"><?php echo e(env('APP_CURRENCY') . number_format($sale->sell_price, 2)); ?></td>
                            <td class="text-center" style="padding: 12px;"><?php echo e($sale->sold_quantity); ?></td>
                            <td class="text-center" style="padding: 12px;"><?php echo e(env('APP_CURRENCY') . number_format($sale->sell_price * $sale->sold_quantity, 2)); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="row no-print">
            <div class="col-12">
                <button onclick="window.print();" class="btn btn-primary btn-lg float-right"><i class="fas fa-print"></i> Print</button>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        /* Additional Custom Styles */
        .invoice-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
        }
        
        .invoice-header {
            margin-bottom: 20px;
            padding-bottom: 20px;
        }
        
        .invoice-info {
            margin-bottom: 30px;
        }

        .invoice-col {
            padding: 15px;
            border: 1px solid #f0f0f0;
            border-radius: 6px;
            background-color: #f9f9f9;
        }

        .table {
            margin-top: 20px;
        }

        .table-bordered th, .table-bordered td {
            border: 1px solid #dee2e6;
        }

        .table th {
            background-color: #f1f1f1;
            text-align: center;
        }

        .table td {
            text-align: center;
            vertical-align: middle;
        }

        .table th, .table td {
            padding: 15px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/sell/sale_invoice.blade.php ENDPATH**/ ?>