<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - Quick Phone</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background: white !important;
            margin: 0;
            padding: 20px;
        }

        .no-print {
            display: block;
        }

        @media print {
            .no-print {
                display: none !important;
            }

            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row no-print mb-3">
            <div class="col-12 text-right">
                <button type="button" class="btn btn-primary btn-sm mr-2" onclick="window.print()">
                    <i class="fas fa-print"></i> Print
                </button>
                <button type="button" class="btn btn-secondary btn-sm" onclick="window.close()">
                    <i class="fas fa-times"></i> Close
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div id="invoice-content">
                        <!DOCTYPE html>
                        <html lang="en">
                        <head>
                            <meta charset="UTF-8">
                            <title>Invoice - Quick Phone</title>
                            <style>
                                body {
                                    font-family: Arial, sans-serif;
                                    font-size: 11px;
                                    line-height: 1.4;
                                    color: #333;
                                    margin: 0;
                                    padding: 0;
                                    background: white;
                                }

                                .invoice-container {
                                    width: 100%;
                                    max-width: 600px;
                                    margin: 0 auto;
                                    padding: 8px;
                                    box-sizing: border-box;
                                    font-size: 12px;
                                }

                                .invoice-header {
                                    text-align: center;
                                    border-bottom: 2px solid #000;
                                    padding-bottom: 5px;
                                    margin-bottom: 12px;
                                }

                                .company-logo {
                                    max-width: 80px;
                                    height: auto;
                                    margin-bottom: 5px;
                                }

                                .company-name {
                                    font-size: 18px;
                                    font-weight: bold;
                                    margin: 3px 0;
                                    text-transform: uppercase;
                                }

                                .company-registration-name {
                                    font-size: 14px;
                                    font-weight: bold;
                                    margin: 2px 0;
                                    text-transform: uppercase;
                                    color: #333;
                                }

                                .company-details {
                                    font-size: 10px;
                                    line-height: 1.3;
                                    margin: 3px 0;
                                }

                                .invoice-info {
                                    display: flex;
                                    justify-content: space-between;
                                    margin-bottom: 12px;
                                    font-size: 11px;
                                }

                                .invoice-info div {
                                    flex: 1;
                                }

                                .customer-info {
                                    margin-bottom: 12px;
                                    font-size: 11px;
                                    border-bottom: 1px solid #000;
                                    padding-bottom: 5px;
                                }

                                table {
                                    width: 100%;
                                    border-collapse: collapse;
                                    margin-bottom: 12px;
                                    font-size: 11px;
                                }

                                th, td {
                                    border: 1px solid #000;
                                    padding: 4px 5px;
                                    text-align: left;
                                    vertical-align: top;
                                }

                                th {
                                    background-color: #f9f9f9;
                                    font-weight: bold;
                                    text-align: center;
                                    font-size: 10px;
                                }

                                .text-center {
                                    text-align: center;
                                }

                                .text-right {
                                    text-align: right;
                                }

                                .totals-section {
                                    width: 50%;
                                    margin-left: auto;
                                    margin-bottom: 12px;
                                }

                                .totals-section table {
                                    margin-bottom: 0;
                                }

                                .totals-section th, .totals-section td {
                                    padding: 3px 5px;
                                    font-size: 11px;
                                }

                                .invoice-footer {
                                    text-align: center;
                                    border-top: 1px solid #000;
                                    padding-top: 5px;
                                    font-size: 9px;
                                    margin-top: 12px;
                                }

                                .print-btn {
                                    display: block;
                                    margin: 20px auto;
                                    padding: 10px 20px;
                                    background-color: #007bff;
                                    color: white;
                                    border: none;
                                    cursor: pointer;
                                    font-size: 14px;
                                    border-radius: 4px;
                                }

                                .print-btn:hover {
                                    background-color: #0056b3;
                                }

                                @media print {
                                    body {
                                        font-size: 9px;
                                    }

                                    .print-btn {
                                        display: none;
                                    }

                                    .invoice-container {
                                        width: 100%;
                                        max-width: none;
                                        margin: 0;
                                        padding: 2px;
                                    }

                                    .company-logo {
                                        max-width: 60px;
                                    }

                                    .company-registration-name {
                                        font-size: 12px;
                                        font-weight: bold;
                                    }

                                    th, td {
                                        padding: 2px 3px;
                                    }

                                    .invoice-header {
                                        margin-bottom: 5px;
                                        padding-bottom: 3px;
                                    }

                                    .invoice-info {
                                        margin-bottom: 5px;
                                    }

                                    .customer-info {
                                        margin-bottom: 5px;
                                        padding-bottom: 3px;
                                    }

                                    table {
                                        margin-bottom: 5px;
                                    }

                                    .totals-section {
                                        margin-bottom: 5px;
                                    }

                                    .invoice-footer {
                                        margin-top: 5px;
                                        padding-top: 3px;
                                    }
                                }
                            </style>
                        </head>

                        <body>
                            <div class="invoice-container" id="invoice">
                                <?php
                                    $currency = $all_settings->currency ?? 'BDT';
                                ?>
                                <!-- Header -->
                                <div class="invoice-header">
                                    <?php if($all_settings && $all_settings->logo_path): ?>
                                        <img src="<?php echo e(asset('logos/' . $all_settings->logo_path)); ?>" alt="Company Logo" class="company-logo" onerror="this.style.display='none'">
                                    <?php endif; ?>
                                    <div class="company-name"><?php echo e($all_settings->company_name ?? 'Quick Phone'); ?></div>
                                    <?php if($all_settings && $all_settings->company_registration_name): ?>
                                        <div class="company-registration-name" style="font-size: 14px; font-weight: bold; margin: 2px 0; text-transform: uppercase;">
                                            <?php echo e($all_settings->company_registration_name); ?>

                                        </div>
                                    <?php endif; ?>
                                    <?php if($all_settings && $all_settings->company_registration_number): ?>
                                        <div style="font-size: 11px; margin: 1px 0; text-align: center;">
                                            📋 Reg No: <?php echo e($all_settings->company_registration_number); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="company-details">
                                        <?php if($all_settings && $all_settings->address): ?>
                                            📍 <?php echo e($all_settings->address); ?><br>
                                        <?php endif; ?>
                                        <?php if($all_settings && $all_settings->number): ?>
                                            � Phone: <?php echo e($all_settings->number); ?>

                                        <?php endif; ?>
                                        <?php if($all_settings && $all_settings->company_email): ?>
                                            | ✉️ <?php echo e($all_settings->company_email); ?><br>
                                        <?php endif; ?>
                                        <?php if($all_settings && $all_settings->website): ?>
                                            🌐 <?php echo e($all_settings->website); ?><br>
                                        <?php endif; ?>

                                    </div>
                                </div>

                                <!-- Invoice Info -->
                                <div class="invoice-info">
                                    <div>
                                        <strong>Invoice No:</strong> INV-<?php echo e($sale->id); ?><br>
                                        <strong>Date:</strong> <?php echo e($sale->created_at->format('d/m/Y')); ?><br>
                                        <strong>Time:</strong> <?php echo e($sale->created_at->format('H:i:s')); ?>

                                    </div>
                                    <div>
                                        <strong>Payment Method:</strong> <?php echo e(ucfirst($sale->payment_method)); ?><br>
                                        <strong>Payment Status:</strong> <?php echo e(ucfirst($sale->payment_status)); ?>

                                    </div>
                                </div>

                                <!-- Customer Info -->
                                <div class="customer-info">
                                    <strong>Bill To:</strong><br>
                                    <?php echo e($sale->customer->name ?? 'Walk-in Customer'); ?><br>
                                    <?php if($sale->customer && $sale->customer->phone): ?>
                                        Phone: <?php echo e($sale->customer->phone); ?><br>
                                    <?php endif; ?>
                                    <?php if($sale->customer && $sale->customer->address): ?>
                                        Address: <?php echo e($sale->customer->address); ?>

                                    <?php endif; ?>
                                </div>

                                <!-- Items Table -->
                                <table>
                                    <thead>
                                        <tr>
                                            <th style="width: 5%">#</th>
                                            <th style="width: 30%">Product</th>
                                            <th style="width: 15%">Brand</th>
                                            <th style="width: 15%">Model</th>
                                            <th style="width: 15%">IMEI/SN</th>
                                            <th style="width: 5%" class="text-center">Qty</th>
                                            <th style="width: 10%" class="text-right">Price</th>
                                            <th style="width: 10%" class="text-right">Subtotal</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $itemCount = 1; ?>
                                        <?php $__currentLoopData = $sale->sellTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-center"><?php echo e($itemCount++); ?></td>
                                                <td><?php echo e($transaction->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($transaction->product->ProductBrand->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($transaction->product->ProductModel->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($transaction->product->imei_or_sn ?? 'N/A'); ?></td>
                                                <td class="text-center"><?php echo e($transaction->sold_quantity ?? 0); ?></td>
                                                <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($transaction->sell_price, 2)); ?></td>
                                                <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($transaction->sell_price * $transaction->sold_quantity, 2)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($sale->exchanges && $sale->exchanges->count() > 0): ?>
                                            <?php $__currentLoopData = $sale->exchanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exchange): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center"><?php echo e($itemCount++); ?></td>
                                                    <td>Exchanged: <?php echo e($exchange->brand->name ?? 'N/A'); ?> <?php echo e($exchange->mobileModel->name ?? 'N/A'); ?></td>
                                                    <td><?php echo e($exchange->brand->name ?? 'N/A'); ?></td>
                                                    <td><?php echo e($exchange->mobileModel->name ?? 'N/A'); ?></td>
                                                    <td><?php echo e($exchange->imei ?? 'N/A'); ?></td>
                                                    <td class="text-center">1</td>
                                                    <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($exchange->price, 2)); ?></td>
                                                    <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($exchange->price, 2)); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>

                                <!-- Totals Section -->
                                <div class="totals-section">
                                    <table>
                                        <tr>
                                            <td class="text-right"><strong>Subtotal:</strong></td>
                                            <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($sale->total_amount, 2)); ?></td>
                                        </tr>
                                        <?php if($sale->discount > 0): ?>
                                            <tr>
                                                <td class="text-right"><strong>Exchange Discount:</strong></td>
                                                <td class="text-right">-<?php echo e($currency); ?> <?php echo e(number_format($sale->discount, 2)); ?></td>
                                            </tr>
                                            <tr>
                                                <td class="text-right"><strong>Net Amount:</strong></td>
                                                <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($sale->net_amount, 2)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        <tr>
                                            <td class="text-right"><strong>Paid Amount:</strong></td>
                                            <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($sale->paid_amount, 2)); ?></td>
                                        </tr>
                                        <?php if($sale->due_amount > 0): ?>
                                            <tr>
                                                <td class="text-right"><strong>Due Amount:</strong></td>
                                                <td class="text-right"><?php echo e($currency); ?> <?php echo e(number_format($sale->due_amount, 2)); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                        <?php
                                            // Calculate customer total outstanding
                                            $customerTotalDue = 0;
                                            if ($sale->customer) {
                                                // Get customer's previous due amount (before this sale)
                                                $previousDue = \App\Models\Sale::where('customer_id', $sale->customer->id)
                                                    ->where('id', '!=', $sale->id)
                                                    ->where('return_status', '!=', 'returned')
                                                    ->sum('due_amount');
                                                
                                                // Add current sale's due amount (0 for paid invoices, amount for credit invoices)
                                                $currentSaleDue = $sale->due_amount ?? 0;
                                                
                                                // Subtract any payments made towards previous due
                                                $previousDuePayments = \App\Models\CustomerPayment::where('customer_id', $sale->customer->id)
                                                    ->where('type', 'due_payment')
                                                    ->sum('amount');
                                                
                                                // For paid invoices: currentSaleDue = 0, so only previous due remains
                                                // For credit invoices: currentSaleDue = sale amount, so total increases
                                                $customerTotalDue = $previousDue + $currentSaleDue - $previousDuePayments;
                                            }
                                        ?>
                                        <?php if($sale->customer && $customerTotalDue > 0): ?>
                                            <tr style="border-top: 2px solid #000;">
                                                <td class="text-right"><strong>Customer Total Outstanding:</strong></td>
                                                <td class="text-right"><strong><?php echo e($currency); ?> <?php echo e(number_format($customerTotalDue, 2)); ?></strong></td>
                                            </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>

                                <!-- Footer -->
                                <div class="invoice-footer">
                                    <p><strong>Thank you for your business!</strong></p>
                                    <p>Terms & Conditions: Goods once sold will not be taken back. Warranty as per manufacturer policy.</p>
                                    <?php if($all_settings): ?>
                                        <p>For any queries, please contact us at 
                                            <?php if($all_settings->number): ?><?php echo e($all_settings->number); ?><?php endif; ?>
                                            <?php if($all_settings->company_email && $all_settings->number): ?> | <?php endif; ?>
                                            <?php if($all_settings->company_email): ?><?php echo e($all_settings->company_email); ?><?php endif; ?>
                                        </p>
                                        <?php if($all_settings->website): ?>
                                            <p>Visit us: <?php echo e($all_settings->website); ?></p>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </body>
                        </html>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/resources/views/sell/invoice-table.blade.php ENDPATH**/ ?>