<!-- Thermal Print Layout -->
<div class="invoice-container thermal-printer">
    <style>
        .thermal-printer {
            width: 72mm;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            margin: 0;
            padding: 10px;
        }
        .thermal-printer h4 {
            text-align: center;
            margin: 0 0 10px 0;
            font-size: 14px;
        }
        .thermal-printer .company-info {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 1px dashed #000;
            padding-bottom: 5px;
        }
        .thermal-printer .company-info h5 {
            margin: 0;
            font-size: 13px;
            font-weight: bold;
        }
        .thermal-printer .company-info p {
            margin: 2px 0;
            font-size: 10px;
        }
        .thermal-printer table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        .thermal-printer th, .thermal-printer td {
            padding: 2px;
            text-align: left;
            font-size: 10px;
        }
        .thermal-printer .total {
            text-align: center;
            font-weight: bold;
            margin-top: 10px;
            border-top: 1px dashed #000;
            padding-top: 5px;
        }
    </style>

    <!-- Company Header -->
    <div class="company-info">
        <?php if(isset($all_settings) && $all_settings): ?>
            <h5><?php echo e($all_settings->company_name ?? 'POS System'); ?></h5>
            <?php if($all_settings->address): ?>
                <p><?php echo e($all_settings->address); ?></p>
            <?php endif; ?>
            <?php if($all_settings->number): ?>
                <p>Tel: <?php echo e($all_settings->number); ?></p>
            <?php endif; ?>
            <?php if($all_settings->company_email): ?>
                <p><?php echo e($all_settings->company_email); ?></p>
            <?php endif; ?>
            <?php if($all_settings->company_registration_number): ?>
                <p>Reg: <?php echo e($all_settings->company_registration_number); ?></p>
            <?php endif; ?>
        <?php else: ?>
            <h5>Your Company, Inc.</h5>
            <p>Company Address</p>
            <p>Phone Number</p>
        <?php endif; ?>
    </div>

    <h4>Sales Invoice</h4>
    <p>Date: <?php echo e(\Carbon\Carbon::parse($sale->sale_date)->format('Y-m-d H:i')); ?></p>
    <p>Customer: <?php echo e($sale->customer_name); ?></p>
    <p>Invoice: #<?php echo e($sale->id ?? 'INV-001'); ?></p>

    <table>
        <tr>
            <th>Item</th>
            <th>Qty</th>
            <th>Price</th>
        </tr>
        <tr>
            <td><?php echo e($sale->product->brand ?? 'Product'); ?></td>
            <td><?php echo e($sale->sold_quantity ?? 1); ?></td>
            <td><?php echo e(($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price, 2)); ?></td>
        </tr>
    </table>

    <div class="total">
        <p><strong>Total: <?php echo e(($all_settings->currency ?? env('APP_CURRENCY', '$')) . number_format($sale->sell_price * ($sale->sold_quantity ?? 1), 2)); ?></strong></p>
    </div>

    <div style="text-align: center; margin-top: 10px; font-size: 10px;">
        <p>Thank you for your business!</p>
        <?php if(isset($all_settings) && $all_settings->website): ?>
            <p><?php echo e($all_settings->website); ?></p>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/quickphone/public_html/bh.quickphone.us/pos/resources/views/invoice/print-thermal.blade.php ENDPATH**/ ?>