<?php
// app/Http/Controllers/InvoiceController.php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\SellTransaction;
use App\Models\Setting;
use App\Models\Brand;
use App\Models\Sale;
use Carbon\Carbon;
use Illuminate\Http\Request;
class InvoiceController extends Controller
{
    public function print($format)
    {
        $sale = Sale::findOrFail(1); // You should dynamically pass the sale ID
        $all_settings = Setting::where('tenant_id', app('tenant')->id)->first();

        switch ($format) {
            case 'thermal':
                return view('invoice.print-thermal', compact('sale', 'all_settings'));
            case 'epson':
                return view('invoice.print-epson', compact('sale', 'all_settings'));
            case 'laser':
                return view('invoice.print-laser', compact('sale', 'all_settings'));
            default:
                return redirect()->back()->with('error', 'Invalid format');
        }
    }
}
