<?php
// app/Http/Controllers/JobSheetController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\JobSheet;
use Illuminate\Support\Facades\Storage;

class JobSheetController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'customer_name' => 'required|string|max:255',
            'customer_number' => 'required|string|max:20',
            'device_brand' => 'required|string|max:100',
            'device_model' => 'required|string|max:100',
            'problem' => 'required|string|max:255',
            'status' => 'required|in:pending,in_progress,completed',
            'phone_picture' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'price' => 'required|numeric|min:0',
        ]);

        $jobSheet = new JobSheet();
        $jobSheet->customer_name = $request->customer_name;
        $jobSheet->customer_number = $request->customer_number;
        $jobSheet->device_brand = $request->device_brand;
        $jobSheet->device_model = $request->device_model;
        $jobSheet->problem = $request->problem;
        $jobSheet->status = $request->status;
        $jobSheet->price = $request->price;

        if ($request->hasFile('phone_picture')) {
            $path = $request->file('phone_picture')->store('phone_pictures', 'public');
            $jobSheet->phone_picture = $path;
        }

        $jobSheet->save();

        // Store the job ID in the session
        session(['job_id' => $jobSheet->id]);

        return redirect()->route('jobsheet.create')->with([
            'success' => 'Job sheet created successfully.',
            'popup' => 'Receipt has been generated successfully.'
        ]);
}

public function create()
    {
        return view('jobsheet.create');
    }

    // Removed duplicate store method to avoid redeclaration error

public function showReport()
{
    // Retrieve all job sheets from the database
    $jobSheets = JobSheet::all();
    
    // Return the view with job sheets data
    return view('jobsheet.report', compact('jobSheets'));
}

public function destroy($id)
{
    $jobSheet = JobSheet::findOrFail($id);
    $jobSheet->delete();

    return redirect()->route('jobsheet.report')->with('success', 'Job sheet deleted successfully.');
}

public function invoice($id)
{
    // Retrieve the job sheet by its ID
    $jobSheet = JobSheet::findOrFail($id);

    // Return the invoice view with the job sheet data
    return view('jobsheet.invoice', compact('jobSheet'));
}

public function receipt($id)
{
    // Retrieve the job sheet by its ID
    $jobSheet = JobSheet::findOrFail($id);

    // Return the receipt view with the job sheet data
    return view('jobsheet.receipt', compact('jobSheet'));
}


}

