<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MobileModel extends Model
{
    protected $fillable = [
        'tenant_id',
        'brand_id',
        'name'
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function resolveRouteBinding($value, $field = null)
    {
        $tenantId = session('tenant_id', 1);
        return $this->where('tenant_id', $tenantId)->findOrFail($value);
    }
}
