@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Plan</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('plans.update', $plan) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $plan->name }}" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description">{{ $plan->description }}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input type="number" step="0.01" class="form-control" id="price" name="price" value="{{ $plan->price }}" required>
                        </div>
                        <div class="form-group">
                            <label for="interval">Interval</label>
                            <select class="form-control" id="interval" name="interval" required>
                                <option value="month" {{ $plan->interval == 'month' ? 'selected' : '' }}>Month</option>
                                <option value="year" {{ $plan->interval == 'year' ? 'selected' : '' }}>Year</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="max_users">Max Users</label>
                            <input type="number" class="form-control" id="max_users" name="max_users" value="{{ $plan->max_users }}" required>
                        </div>
                        <div class="form-group">
                            <label for="max_products">Max Products</label>
                            <input type="number" class="form-control" id="max_products" name="max_products" value="{{ $plan->max_products }}" required>
                        </div>
                        <div class="form-group">
                            <label for="features">Features (JSON)</label>
                            <textarea class="form-control" id="features" name="features">{{ $plan->features }}</textarea>
                        </div>
                        <div class="form-group">
                            <label for="is_active">Active</label>
                            <input type="checkbox" id="is_active" name="is_active" value="1" {{ $plan->is_active ? 'checked' : '' }}>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
