@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Plans</h3>
                    <a href="{{ route('plans.create') }}" class="btn btn-primary float-right">Create Plan</a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Price</th>
                                <th>Interval</th>
                                <th>Max Users</th>
                                <th>Max Products</th>
                                <th>Active</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($plans as $plan)
                            <tr>
                                <td>{{ $plan->id }}</td>
                                <td>{{ $plan->name }}</td>
                                <td>{{ $plan->description }}</td>
                                <td>${{ $plan->price }}</td>
                                <td>{{ $plan->interval }}</td>
                                <td>{{ $plan->max_users }}</td>
                                <td>{{ $plan->max_products }}</td>
                                <td>{{ $plan->is_active ? 'Yes' : 'No' }}</td>
                                <td>
                                    <a href="{{ route('plans.show', $plan) }}" class="btn btn-info btn-sm">View</a>
                                    <a href="{{ route('plans.edit', $plan) }}" class="btn btn-warning btn-sm">Edit</a>
                                    <form action="{{ route('plans.destroy', $plan) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
