@extends('layouts.app')

@section('main')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Subscriptions</h3>
                    <a href="{{ route('subscriptions.create') }}" class="btn btn-primary float-right">Create Subscription</a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Tenant</th>
                                <th>Plan</th>
                                <th>Status</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Price</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($subscriptions as $subscription)
                        <tr>
                            <td>{{ $subscription->id }}</td>
                            <td>{{ $subscription->tenant->name ?? 'N/A' }}</td>
                            <td>{{ $subscription->plan->name ?? 'N/A' }}</td>
                            <td>{{ $subscription->status }}</td>
                            <td>{{ $subscription->start_date }}</td>
                            <td>{{ $subscription->end_date }}</td>
                            <td>${{ $subscription->price }}</td>
                            <td>
                                <a href="{{ route('subscriptions.show', $subscription) }}" class="btn btn-info btn-sm">View</a>
                                <a href="{{ route('subscriptions.edit', $subscription) }}" class="btn btn-warning btn-sm">Edit</a>
                                @if($subscription->status == 'pending')
                                <form action="{{ route('subscriptions.approve', $subscription) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Approve this subscription?')">Approve</button>
                                </form>
                                @endif
                                <form action="{{ route('subscriptions.destroy', $subscription) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
