@extends('layouts.app')
@push('style')
    <style>
        /* Style for the search results dropdown */
        #customer_results {
            position: absolute;
            z-index: 1000;
            /* Ensure it appears above other elements */
            background-color: #fff;
            border: 1px solid #ccc;
            border-top: none;
            max-height: 200px;
            overflow-y: auto;
            width: 100%;
            /* Match the width of the input field */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Style for individual search items */
        .search-item {
            padding: 8px 12px;
            cursor: pointer;
            list-style-type: none;
            /* Remove bullet points */
        }

        .search-item:hover {
            background-color: #f8f9fa;
            /* Highlight on hover */
        }

        /* Hide the dropdown by default */
        #customer_results {
            display: none;
        }
    </style>
@endpush
@section('main')
    {{-- {{ $brands }} --}}
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Project Add</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active">Project Add</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
        {{-- =============================================== --}}
        @if (session('success'))
            {{-- <div class="alert alert-success">
                {{ session('success') }}
            </div> --}}
            <div class="modal fade show" style="display: block;" id="print_invoice_modal">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                Product Added Successfully!
                            </h4>

                        </div>

                        <div class="modal-body">
                            <div class="popup-content">
                                <a href="{{ route('product.print', session('success')) }}" target="_blank"
                                    class="btn btn-block btn-outline-success btn-sm">
                                    Print Receipt
                                </a>
                                <button type="button" class="btn btn-block btn-outline-danger btn-sm"
                                    id="close_modal_btn">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        {{-- =============================================== --}}
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">General</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                                title="Collapse">
                                <i class="fas fa-minus"></i></button>
                        </div>
                    </div>
                    <form method="POST" action="{{ route('product.store') }}">
                        @csrf
                        <!-- Customer Info -->
                        <div class="card-body">
                            <div class="form-group">
                                <label for="customer_search">Search Customer:</label>
                                <input type="text" class="form-control" id="customer_search"
                                    placeholder="Search by name or mobile..." autocomplete="off">
                                <input type="hidden" id="customer_info" name="customer_info" readonly>
                                <div id="customer_results" class="search-results"></div> <!-- Dropdown for results -->

                                <button type="button" data-toggle="modal" data-target="#modal-add-customer"
                                    class="btn btn-block">
                                    <i class="fas fa-plus"></i> Add New Customer
                                </button>

                            </div>

                            <!-- Mobile Brand -->
                            <div class="form-group">
                                <label for="brand">Mobile Brand:</label>
                                <select id="brandDropdown" class="form-control" name="brand" required>
                                    <option value="">-- Select Brand --</option>
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                    @endforeach

                                </select>
                                <button type="button" class="btn btn-block" data-toggle="modal"
                                    data-target="#modal-add-brand">+</button>
                            </div>

                            <!-- Mobile Model -->
                            <div class="form-group">
                                <label for="model">Mobile Model:</label>
                                <select id="modelDropdown" class="form-control" name="model" required>
                                    <option value="">-- Select Model --</option>
                                    <!-- Models will be populated here dynamically -->
                                </select>
                                <!-- Button to open model modal -->
                                <button type="button" id="openAddModelModal" class="btn btn-block" data-toggle="modal"
                                    data-target="#modal-add-model">+</button>
                            </div>

                            <!-- IMEI/SN Number -->
                            <div class="form-group">
                                <label for="imei_or_sn">IMEI/SN Number:</label>
                                <input type="text" class="form-control" id="imei_or_sn" name="imei_or_sn" required>
                            </div>

                            <!-- Condition -->
                            <div class="form-group">
                                <label for="condition">Condition:</label>
                                <select id="condition" class="form-control" name="condition" required>
                                    <option value="new">New</option>
                                    <option value="old">Old</option>
                                </select>
                            </div>

                            <!-- Color -->
                            <div class="form-group">
                                <label for="color">Phone Color:</label>
                                <select id="color" class="form-control" name="color" required>
                                    <option value="Black">Black</option>
                                    <option value="White">White</option>
                                    <option value="Silver">Silver</option>
                                    <option value="Gold">Gold</option>
                                    <option value="Rose Gold">Rose Gold</option>
                                    <option value="Blue">Blue</option>
                                    <option value="Green">Green</option>
                                    <option value="Purple">Purple</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="gb">Storage (GB):</label>
                                <select id="gb" class="form-control" name="gb" required>
                                    <option value="16">16 GB</option>
                                    <option value="32">32 GB</option>
                                    <option value="64">64 GB</option>
                                    <option value="128">128 GB</option>
                                    <option value="256">256 GB</option>
                                    <option value="512">512 GB</option>
                                    <option value="1024">1 TB</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="buy_price">Buy Price:</label>
                                <input type="number" class="form-control" step="0.01" id="buy_price"
                                    name="buy_price" required>
                            </div>

                            <div class="form-group">
                                <label for="stock">Stock Quantity:</label>
                                <input type="number" class="form-control" id="stock" value="1" name="stock"
                                    required>
                            </div>

                            <button type="submit" class="btn btn-block bg-gradient-primary">Add Product and Generate
                                Receipt</button>

                            <!-- Popup will display here after successful form submission -->
                    </form>
                </div>


            </div>
            <!-- /.card -->
        </div>
        <div class="col-md-6">
            <div class="card card-secondary">
                <div class="card-header">
                    <h3 class="card-title">Direct Add Product</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip"
                            title="Collapse">
                            <i class="fas fa-minus"></i></button>
                    </div>
                </div>
                <form method="POST" action="{{ route('product.direct.store') }}">
    @csrf
    <div class="card-body">
        <!-- Instructions -->
        <div class="alert alert-info" role="alert">
            <i class="fas fa-info-circle"></i> <strong>Smart Product Entry:</strong>
            <br>• Type product name to search existing products
            <br>• Click found products to update stock instead of creating duplicates
            <br>• New products will be created if no matches found
        </div>
        <!-- Product Type (Brand) -->
        <div class="form-group">
            <label for="ProductType">Product Type:</label>
            <select id="ProductType" class="form-control" name="ProductType" required>
                <option value="">-- Select Product Type --</option>
                <option value="Repair">Repair</option>
                <option value="Accessories">Accessories</option>
                <option value="Phone">Phone</option>
                <option value="Others">Others</option>
            </select>
        </div>

        <!-- Product Name (Model) -->
        <div class="form-group">
            <label for="product_name">Item Name :</label>
            <input type="text" class="form-control" id="product_name" name="product_name" placeholder="Enter model name (type to search existing)" required autocomplete="off">
            <div id="product_search_results" class="search-dropdown"></div>
            <small class="form-text text-muted">Start typing to search existing products and update their stock.</small>
            <button type="button" id="test_search" class="btn btn-sm btn-info mt-1">Test Search</button>
        </div>

        <!-- Buy Price -->
        <div class="form-group">
            <label for="item_price">Buy Price:</label>
            <input type="number" class="form-control" step="0.01" id="item_price" name="item_price" placeholder="Enter price" required>
        </div>

        <!-- Stock Quantity -->
        <div class="form-group">
            <label for="stock_quantity">Stock Quantity:</label>
            <input type="number" class="form-control" id="stock_quantity" name="stock_quantity" placeholder="Enter stock quantity" required>
        </div>
    </div>

    <div class="card-footer">
        <button type="submit" class="btn btn-block bg-gradient-info">Save Product</button>
    </div>
</form>


    {{-- Add Customer --}}
    <div class="modal fade" id="modal-add-customer">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Customer</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form id="customer_form">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="customer_name">Customer Name:</label>
                        <input type="text" id="customer_name" class="form-control" name="customer_name" required>

                        <label for="customer_number">Customer Number:</label>
                        <input type="tel" id="customer_number" class="form-control" name="customer_number" required>

                        <label for="customer_cpr">Customer CPR:</label>
                        <input type="text" id="customer_cpr" class="form-control" name="customer_cpr">

                        <label for="address">Address:</label>
                        <input type="text" id="address" class="form-control" name="address">

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Customer</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Customer --}}

    {{-- Add Brand --}}
    <div class="modal fade" id="modal-add-brand">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Brand</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form method="POST" action="{{ route('brand.store') }}">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="brand_name">Brand Name:</label>
                        <input type="text" id="brand_name" class="form-control" name="brand_name" required>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Brand</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Brand --}}

    {{-- Add Mobile Model --}}
    <div class="modal fade" id="modal-add-model">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add New Model</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        {{-- <span aria-hidden="true">&times;</span> --}}
                    </button>
                </div>
                <form method="POST" action="{{ route('mobile-models.store') }}">
                    @csrf <!-- CSRF Token -->
                    <div class="modal-body">
                        <label for="model_name">Model Name:</label>
                        <input type="hidden" id="brand_id" name="brand_id" required>
                        <input type="text" id="model_name" class="form-control" name="model_name" required>


                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Model</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- Add Mobile Model --}}
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            console.log("Document ready - jQuery loaded successfully!");
            console.log("Product name field exists:", $("#product_name").length > 0);

            // +++++++++++++++++++++++++   ( 5 )    ++++++++++++++++++++++++++++++++++++++++
            $("#close_modal_btn").click(function() {
                $("#print_invoice_modal").hide(); // Hides the modal
            });

            // Also hide modal when clicking outside of it
            $(window).click(function(event) {
                if ($(event.target).is("#print_invoice_modal")) {
                    $("#print_invoice_modal").hide();
                }
            });
            // +++++++++++++++++++++++++   ( 5 )    ++++++++++++++++++++++++++++++++++++++++

            // +++++++++++++++++++++++++   ( 4 )    ++++++++++++++++++++++++++++++++++++++++
            $('#openAddModelModal').click(function() {
                var brandId = $('#brandDropdown').val(); // Get selected brand ID
                $("#brand_id").val(brandId)
                if (!brandId) {
                    $('#modal-add-model button[type="submit"]').hide();
                    alert('Please select a brand first!');
                    return; // Stop the modal from opening if no brand is selected
                }

                $('#modal-add-model button[type="submit"]').show();
                // Open modal if a brand is selected
                // $('#modal-add-model').modal('show');
            });
            // +++++++++++++++++++++++++   ( 4 )    ++++++++++++++++++++++++++++++++++++++++

            // +++++++++++++++++++++++++   ( 3 )    ++++++++++++++++++++++++++++++++++++++++
            $('#brandDropdown').on('change', function() {
                var brandId = $(this).val(); // Get selected brand ID

                if (brandId) {
                    $.ajax({
                        url: "{{ route('get.models', '') }}/" + brandId, // Call Laravel route
                        type: "GET",
                        success: function(response) {
                            console.log("modelDropdown", response);
                            if (response.success) {
                                var modelDropdown = $('#modelDropdown');
                                modelDropdown.empty(); // Clear existing options
                                modelDropdown.append(
                                    '<option value="">-- Select Model --</option>');

                                $.each(response.models, function(key, model) {
                                    modelDropdown.append('<option value="' + model.id +
                                        '">' + model.name + '</option>');
                                });
                            } else {
                                alert('Error: ' + response.message);
                            }
                        },
                        error: function() {
                            alert("Error fetching models.");
                        }
                    });
                } else {
                    $('#modelDropdown').html(
                        '<option value="">-- Select Model --</option>'
                    ); // Reset models if no brand is selected
                }
            });
            // +++++++++++++++++++++++++   ( 3 )    ++++++++++++++++++++++++++++++++++++++++



            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++
            $('#customer_form').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                $.ajax({
                    url: "{{ route('customer.store') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function(response, status, xhr) {
                        if (xhr.status === 201) { // HTTP 201 Created
                            $('#customer_form')[0].reset(); // Reset the form
                            $('#modal-add-customer').modal('hide'); // Hide modal
                            alert(response.message);
                        } else {
                            console.log("Unexpected response status: " + xhr.status);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) { // Validation error
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = Object.values(errors).flat().join("\n");
                            alert("Validation Error:\n" + errorMessages);
                        } else if (xhr.status === 500) { // Server error
                            alert("Server Error! Please try again.");
                        } else {
                            alert("An error occurred. Status: " + xhr.status);
                        }
                        console.log(xhr.responseText);
                    }
                });
            });
            // +++++++++++++++++++++++++   ( 2 )    ++++++++++++++++++++++++++++++++++++++++


            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
            $("#customer_search").on("keyup", function() {
                let query = $(this).val().trim();
                if (query.length < 2) {
                    $("#customer_results").html("").hide(); // Hide if query is too short
                    return;
                }

                $.ajax({
                    url: "{{ route('api.customers.search') }}",
                    type: "GET",
                    data: {
                        query: query
                    },
                    success: function(response) {
                        let resultHTML = "";
                        if (response.length > 0) {
                            resultHTML += '<ul class="">';
                            $.each(response, function(index, customer) {
                                resultHTML += `<li class=" search-item" data-id="${customer.id}" data-name="${customer.name}" data-number="${customer.number}">
                            <strong>${customer.name}</strong> - ${customer.number}
                        </li>`;
                            });
                            resultHTML += '</ul>';
                        } else {
                            resultHTML =
                                '<p class="dropdown-item text-muted">No results found</p>';
                        }

                        $("#customer_results").html(resultHTML).show(); // Show results
                    }
                });
            });

            // Handle selection
            $(document).on("click", ".search-item", function() {
                let customerId = $(this).data("id");
                let customerName = $(this).data("name");
                let customerNumber = $(this).data("number");

                $("#customer_search").val(`${customerName} (${customerNumber})`);
                $("#customer_info").val(customerId); // Store customer ID
                $("#customer_results").hide(); // Hide dropdown after selection
            });

            // Hide dropdown on clicking outside
            $(document).on("click", function(e) {
                if (!$(e.target).closest("#customer_search, #customer_results").length) {
                    $("#customer_results").hide();
                }
            });
            // +++++++++++++++++++++++++   ( 1 )    ++++++++++++++++++++++++++++++++++++++++
            
            // Test search functionality
            $("#test_search").click(function() {
                alert("Test search button clicked! Check console for details.");
                console.log("Test search clicked - jQuery is working");
                testSearchFunction();
            });

            // Product name auto-search functionality
            $("#product_name").on("input keyup", function() {
                var query = $(this).val().trim();
                console.log("Input changed, query:", query);
                
                if (query.length >= 2) {
                    console.log("Query length >= 2, searching...");
                    searchExistingProducts(query);
                } else {
                    $("#product_search_results").hide().empty();
                    console.log("Query too short, hiding results");
                }
            });

            // Hide search results when clicking outside
            $(document).click(function(e) {
                if (!$(e.target).closest("#product_name, #product_search_results").length) {
                    $("#product_search_results").hide();
                }
            });

            function testSearchFunction() {
                console.log("Testing search with 'Test'");
                console.log("Route URL: {{ route('product.search') }}");
                
                // Test basic connectivity first
                $.ajax({
                    url: "{{ route('product.search') }}",
                    method: "GET",
                    data: { q: "Test" },
                    success: function(response) {
                        console.log("Test search successful:", response);
                        alert("Search test successful! Found " + response.length + " products.");
                    },
                    error: function(xhr, status, error) {
                        console.error("Test search failed:");
                        console.error("Status:", xhr.status);
                        console.error("Error:", error);
                        console.error("Response:", xhr.responseText);
                        alert("Search test failed: " + xhr.status + " - " + error);
                    }
                });
            }

            function searchExistingProducts(query) {
                console.log("Searching for products with query:", query);
                
                // Show loading indicator
                $("#product_search_results").html('<div style="padding: 10px; background: white; border: 1px solid #ccc;">Searching...</div>').show();
                
                $.ajax({
                    url: "{{ route('product.search') }}",
                    method: "GET",
                    data: { q: query },
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    success: function(response) {
                        console.log("Search successful, found " + response.length + " products:", response);
                        showSearchResults(response);
                    },
                    error: function(xhr, status, error) {
                        console.error("Search failed:", status, error);
                        console.error("Status Code:", xhr.status);
                        console.error("Response:", xhr.responseText);
                        
                        var errorMsg = "Search failed: ";
                        if (xhr.status === 404) {
                            errorMsg += "Route not found";
                        } else if (xhr.status === 401) {
                            errorMsg += "Authentication required";
                        } else if (xhr.status === 500) {
                            errorMsg += "Server error";
                        } else {
                            errorMsg += error;
                        }
                        
                        $("#product_search_results").html('<div style="padding: 10px; background: white; border: 1px solid #ccc; color: red;">' + errorMsg + '</div>').show();
                        setTimeout(function() {
                            $("#product_search_results").hide();
                        }, 3000);
                    }
                });
            }

            function showSearchResults(products) {
                console.log("Showing search results for", products.length, "products");
                var resultsDiv = $("#product_search_results");
                resultsDiv.empty();

                if (products && products.length > 0) {
                    var html = '<div style="background: white; border: 2px solid #007bff; max-height: 200px; overflow-y: auto; position: absolute; z-index: 1000; width: 100%; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">';
                    html += '<div style="background: #007bff; color: white; padding: 8px; font-weight: bold; text-align: center;">🔍 Found ' + products.length + ' existing product(s) - Click to update stock:</div>';
                    
                    $.each(products, function(index, product) {
                        html += '<div class="search-item" data-id="' + product.id + '" style="padding: 12px; cursor: pointer; border-bottom: 1px solid #eee; transition: all 0.3s;" onmouseover="this.style.backgroundColor=\'#f0f8ff\'" onmouseout="this.style.backgroundColor=\'white\'">';
                        html += '<div style="display: flex; justify-content: space-between; align-items: center;">';
                        html += '<div>';
                        html += '<strong style="color: #333; font-size: 14px;">' + product.name + '</strong>';
                        html += '<br><small style="color: #666;">Current Stock: <span style="color: #28a745; font-weight: bold;">' + product.stock + '</span> | Price: <span style="color: #007bff; font-weight: bold;">BHD ' + parseFloat(product.buy_price).toFixed(2) + '</span></small>';
                        html += '</div>';
                        html += '<div style="background: #28a745; color: white; padding: 5px 10px; border-radius: 15px; font-size: 11px; font-weight: bold;">📦 UPDATE STOCK</div>';
                        html += '</div>';
                        html += '</div>';
                    });
                    
                    html += '</div>';
                    resultsDiv.html(html).show();
                    
                    // Add click handlers with visual feedback
                    resultsDiv.find('.search-item').click(function() {
                        console.log("Product clicked");
                        var productId = $(this).data('id');
                        var product = products.find(function(p) { return p.id == productId; });
                        if (product) {
                            // Visual feedback
                            $(this).css('background-color', '#d4edda');
                            selectProduct(product);
                        }
                    });
                } else {
                    resultsDiv.html('<div style="background: #fff3cd; border: 2px solid #ffc107; padding: 10px; position: absolute; z-index: 1000; width: 100%; text-align: center; color: #856404;">⚠️ No existing products found. You can create a new one.</div>').show();
                    setTimeout(function() {
                        resultsDiv.hide();
                    }, 3000);
                }
            }

            function selectProduct(product) {
                console.log("Selected product:", product);
                
                $("#product_search_results").hide();
                
                // Show detailed confirmation dialog
                var message = "📦 EXISTING PRODUCT FOUND!\n\n";
                message += "Product: " + product.name + "\n";
                message += "Current Stock: " + product.stock + " units\n";
                message += "Current Price: BHD " + parseFloat(product.buy_price).toFixed(2) + "\n\n";
                message += "Enter additional stock to add to existing inventory:";
                
                var additionalStock = prompt(message, "1");
                
                if (additionalStock !== null) {
                    if (!isNaN(additionalStock) && parseInt(additionalStock) > 0) {
                        var newTotal = product.stock + parseInt(additionalStock);
                        if (confirm("Confirm stock update?\n\nCurrent: " + product.stock + " units\nAdding: " + additionalStock + " units\nNew Total: " + newTotal + " units")) {
                            updateStock(product.id, parseInt(additionalStock), product.name, product.stock);
                        }
                    } else {
                        alert("❌ Please enter a valid positive number for additional stock.");
                    }
                }
            }

            function updateStock(productId, additionalStock, productName, oldStock) {
                console.log("Updating stock - ID:", productId, "Additional:", additionalStock);
                
                // Show loading message
                alert("⏳ Updating stock for '" + productName + "'...\nPlease wait...");
                
                $.ajax({
                    url: "{{ route('product.updateStock') }}",
                    method: "POST",
                    data: {
                        product_id: productId,
                        additional_stock: additionalStock,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        console.log("Stock update response:", response);
                        
                        var successMessage = "✅ STOCK UPDATED SUCCESSFULLY!\n\n";
                        successMessage += "Product: " + productName + "\n";
                        successMessage += "Previous Stock: " + oldStock + " units\n";
                        successMessage += "Added: " + additionalStock + " units\n";
                        successMessage += "New Total Stock: " + response.new_stock + " units";
                        
                        alert(successMessage);
                        
                        // Clear form for next entry
                        $("#ProductType").val("");
                        $("#product_name").val("");
                        $("#item_price").val("");
                        $("#stock_quantity").val("");
                        
                        // Focus back to product name for next entry
                        $("#product_name").focus();
                    },
                    error: function(xhr, status, error) {
                        console.error("Stock update failed:", xhr.responseText);
                        var errorMsg = "❌ ERROR UPDATING STOCK\n\n";
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMsg += xhr.responseJSON.message;
                        } else {
                            errorMsg += "Please check your internet connection and try again.";
                        }
                        alert(errorMsg);
                    }
                });
            }
        });
    </script>

    <style>
        .search-results {
            position: relative;
            z-index: 1000;
        }

        .search-results-container {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-height: 300px;
            overflow-y: auto;
        }

        .search-header {
            background: #f8f9fa;
            padding: 8px 12px;
            font-size: 12px;
            font-weight: bold;
            color: #6c757d;
            border-bottom: 1px solid #eee;
        }

        .search-result-item {
            padding: 12px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: background-color 0.2s;
        }

        .search-result-item:hover {
            background-color: #f8f9fa;
        }

        .search-result-item:last-child {
            border-bottom: none;
        }

        .product-info {
            flex: 1;
        }

        .update-badge {
            background: #007bff;
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
        }

        .search-result-item:hover .update-badge {
            background: #0056b3;
        }

        .search-dropdown {
            position: relative;
        }

        .search-item:hover {
            background-color: #f8f9fa !important;
        }
    </style>
@endpush
