@extends('layouts.app')

@section('main')
    <h1>Sales Report</h1>

    <form method="GET" action="{{ route('report.index') }}">
        <div class="row">
            <div class="col-md-4">
                <select name="filter_date" class="form-control" onchange="this.form.submit()">
                    <option value="all" {{ request('filter_date') == 'all' ? 'selected' : '' }}>All Time</option>
                    <option value="today" {{ request('filter_date') == 'today' ? 'selected' : '' }}>Today</option>
                    <option value="yesterday" {{ request('filter_date') == 'yesterday' ? 'selected' : '' }}>Yesterday
                    </option>
                    <option value="last_7_days" {{ request('filter_date') == 'last_7_days' ? 'selected' : '' }}>Last 7 Days
                    </option>
                    <option value="last_30_days" {{ request('filter_date') == 'last_30_days' ? 'selected' : '' }}>Last 30
                        Days</option>
                    <option value="last_year" {{ request('filter_date') == 'last_year' ? 'selected' : '' }}>Last Year
                    </option>
                    <option value="custom" {{ request('filter_date') == 'custom' ? 'selected' : '' }}>Custom Date</option>
                </select>
            </div>
            <div class="col-md-4" id="custom-date-picker"
                style="display: {{ request('filter_date') == 'custom' ? 'block' : 'none' }};">
                <div class="input-group">
                    <input type="text" name="start_date" class="form-control" id="start_date" placeholder="Start Date"
                        value="{{ request('start_date') }}">
                    <input type="text" name="end_date" class="form-control" id="end_date" placeholder="End Date"
                        value="{{ request('end_date') }}">
                </div>
            </div>
        </div>
    </form>

    <div class="row">
        <div class="col-lg-4 col-md-6 col-12">
            <div class="info-box">
                <span class="info-box-icon bg-aqua animated tada"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Direct Sales Profit</span>
                    <span
                        class="info-box-number">{{ $all_settings->currency }}{{ number_format($directSalesProfit, 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-6 col-12">
            <div class="info-box">
                <span class="info-box-icon bg-green animated tada"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Total Sell Transactions Profit</span>
                    <span
                        class="info-box-number">{{ $all_settings->currency }}{{ number_format($sellTransactionsProfit, 2) }}</span>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-6 col-12">
            <div class="info-box">
                <span class="info-box-icon bg-yellow animated tada"><i class="fas fa-dollar-sign"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Net Profit</span>
                    <span class="info-box-number">{{ $all_settings->currency }}{{ number_format($netProfit, 2) }}</span>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Sales Transactions</h3>
        </div>
        <div class="card-body">
            <table id="salesTransactionsTable" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Date</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($combinedSales as $sale)
                        <tr>
                            <td>{{ $sale['type'] }}</td>
                            <td>{{ $sale['date'] }}</td>
                            <td>{{ $all_settings->currency }}{{ number_format($sale['profit'], 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
@endsection

@section('css')
    <link rel="stylesheet" href="/css/admin_custom.css">
    <link rel="stylesheet" href="/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
    <link rel="stylesheet" href="/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
    <link rel="stylesheet" href="/plugins/datepicker/datepicker3.css">
@endsection

@section('js')
    <script src="/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="/plugins/jszip/jszip.min.js"></script>
    <script src="/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script src="/plugins/datepicker/bootstrap-datepicker.min.js"></script>

    <script>
        $(function() {
            $("#salesTransactionsTable").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#salesTransactionsTable_wrapper .col-md-6:eq(0)');

            // Initialize datepickers for custom filter
            $('#start_date, #end_date').datepicker({
                autoclose: true,
                format: 'yyyy-mm-dd'
            });

            // Show/Hide custom date picker based on filter selection
            $('select[name="filter_date"]').on('change', function() {
                if (this.value === 'custom') {
                    $('#custom-date-picker').show();
                } else {
                    $('#custom-date-picker').hide();
                }
            });
        });
    </script>
@endsection
