@extends('layouts.app')

@section('title', 'Company Settings')

@section('content')
<div class="container mt-4">
    <h1 class="my-4">Company Settings</h1>

    <!-- Success message -->
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- Company Info -->
    <div class="card">
        <div class="card-header">
            <h3>Company Information</h3>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Company Name:</strong>
                    <p>{{ $settings->company_name ?? 'Not provided' }}</p>
                </div>
                <div class="col-md-6">
                    <strong>Company Registration Number:</strong>
                    <p>{{ $settings->company_registration_number ?? 'Not provided' }}</p>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Company Email:</strong>
                    <p>{{ $settings->company_email ?? 'Not provided' }}</p>
                </div>
                <div class="col-md-6">
                    <strong>Website:</strong>
                    <p><a href="{{ $settings->website ?? '#' }}" target="_blank">{{ $settings->website ?? 'Not provided' }}</a></p>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Phone Number:</strong>
                    <p>{{ $settings->number ?? 'Not provided' }}</p>
                </div>
                <div class="col-md-6">
                    <strong>Address:</strong>
                    <p>{{ $settings->address ?? 'Not provided' }}</p>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>Time Zone:</strong>
                    <p>{{ $settings->time_zone ?? 'Not provided' }}</p>
                </div>
                <div class="col-md-6">
                    <strong>Currency:</strong>
                    <p>{{ $settings->currency ?? 'Not provided' }}</p>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <strong>POS Price Type:</strong>
                    <p>{{ $settings->pos_price_type ?? 'Not provided' }}</p>
                </div>
                <div class="col-md-6">
                    <strong>POS Price Value:</strong>
                    <p>{{ $settings->pos_price_value ?? 'Not provided' }}</p>
                </div>
            </div>

            <!-- Display logo if it exists -->
            @if($settings->logo_path)
                <div class="row mb-3">
                    <div class="col-md-12">
                        <strong>Company Logo:</strong><br>
                        <img src="{{ asset('logos/' . $settings->logo_path) }}" alt="Logo" class="img-fluid" width="200px">
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
