{{-- WhatsApp Send Button Component --}}
@php
    $buttonSize = $size ?? 'md';
    $buttonClass = match($buttonSize) {
        'sm' => 'btn-sm',
        'lg' => 'btn-lg',
        default => ''
    };
    $iconSize = match($buttonSize) {
        'sm' => 'fa-sm',
        'lg' => 'fa-lg',
        default => ''
    };
    
    // Get customer phone number
    $customerPhone = '';
    $hasValidPhone = false;
    
    if (isset($data->customer) && $data->customer) {
        $phone = $data->customer->phone ?? '';
        // Check if phone is valid (not empty, not default values)
        if ($phone && $phone !== '00000000' && strlen(trim($phone)) > 5) {
            $customerPhone = $phone;
            $hasValidPhone = true;
        }
    }
@endphp

@if($hasValidPhone)
<button type="button" 
        class="btn btn-success {{ $buttonClass }} whatsapp-send-btn" 
        title="Send {{ ucfirst($type) }} via WhatsApp to {{ $customerPhone }}"
        data-type="{{ $type }}"
        data-id="{{ $data->id }}"
        data-phone="{{ $customerPhone }}"
        onclick="sendWhatsAppMessage(this)">
    <i class="fab fa-whatsapp {{ $iconSize }}"></i>
    @if($buttonSize !== 'sm')
        Send {{ ucfirst($type) }}
    @endif
</button>
@else
<button type="button" 
        class="btn btn-secondary {{ $buttonClass }}" 
        title="Customer mobile number not available for WhatsApp"
        disabled>
    <i class="fas fa-phone-slash {{ $iconSize }}"></i>
    @if($buttonSize !== 'sm')
        No Phone
    @endif
</button>
@endif

@push('scripts')
<script>
function sendWhatsAppMessage(button) {
    const type = button.dataset.type;
    const id = button.dataset.id;
    const phone = button.dataset.phone;
    
    // Show loading state
    const originalHtml = button.innerHTML;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Opening...';
    button.disabled = true;
    
    // Get WhatsApp URL from server
    fetch('{{ route('whatsapp.send.invoice') }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            type: type,
            id: id,
            phone: phone,
            get_url_only: true // Flag to get URL instead of sending
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success && data.whatsapp_url) {
            // Open WhatsApp in new tab/window
            window.open(data.whatsapp_url, '_blank');
            showAlert('success', 'WhatsApp opened successfully! Please send the message from WhatsApp.');
        } else {
            showAlert('error', data.message || 'Failed to generate WhatsApp URL');
        }
    })
    .catch(error => {
        console.error('WhatsApp URL error:', error);
        showAlert('error', 'An error occurred while generating the WhatsApp URL');
    })
    .finally(() => {
        // Restore button state
        button.innerHTML = originalHtml;
        button.disabled = false;
    });
}

function showAlert(type, message) {
    // Try to use toastr if available, otherwise use bootstrap alerts
    if (typeof toastr !== 'undefined') {
        if (type === 'success') {
            toastr.success(message);
        } else {
            toastr.error(message);
        }
        return;
    }
    
    // Fallback to bootstrap alerts
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    
    // Find container and show alert
    let alertContainer = document.querySelector('#alert-container');
    if (!alertContainer) {
        alertContainer = document.createElement('div');
        alertContainer.id = 'alert-container';
        alertContainer.className = 'position-fixed top-0 end-0 p-3';
        alertContainer.style.zIndex = '9999';
        document.body.appendChild(alertContainer);
    }
    
    alertContainer.innerHTML = alertHtml;
    
    // Auto-hide success alerts after 5 seconds
    if (type === 'success') {
        setTimeout(() => {
            const alert = alertContainer.querySelector('.alert');
            if (alert) {
                alert.remove();
            }
        }, 5000);
    }
}
</script>
@endpush